;Simple platform engine v1.0


Type player
     Field x,y  ;X and y position of player
     Field mode$ ;Mode of player. like "jumps" "Falls"
     Field yspeed# ; Yspeed of player
     Field xspeed# ; Xspeed of player :)
End Type

;Controlls
Const K_Up    = 200
Const K_Down  = 208
Const K_Left  = 203
Const K_Right = 205


Const Map_height=47
Const Map_with=93
Global offsetx#=0
Global offsety#=0

Dim map(Map_with,Map_height) ; This is storage for mapdata.

;Read map data into array
Restore mapdata
For y=0 To Map_height
     Read row$
     For x=0 To Map_with
          obj=Asc(Mid$(row$,x+1,1))-Asc("0") ;Read one charter to a real number
          map(x,y)=obj ;Store that nuber in array.
     Next
Next




;Sets up gfx
Graphics 640,480,16,2
SetBuffer BackBuffer()

offsety=0
offsetx=0
     
players.player = New player
players\x#=100
players\y#=100
players\mode$="normal"
players\yspeed#=0
players\xspeed#=0


While Not KeyHit(1)

     camera_handle()

     playercontrolls()

     redraw()
     

     Flip True


Wend




;This is where we moves player around.
Function playercontrolls()

     players.player = First player

     ;lets store xspeed cause sometimes we need it other whise then player hitts head it loses its x speed.
     oldxspeed#=players\xspeed#
     oldx#=players\x#
     

     move=False
     If KeyDown(k_left) Then players\xspeed#=players\xspeed#-0.5 : move=True
     If KeyDown(k_right) Then players\xspeed#=players\xspeed#+0.5 : move=True
     
     players\xspeed#=players\xspeed#*0.95 ;this makes player Stop If Not moving.
     
     ;Check for max x speed limit.
     If players\xspeed#>31 Then players\xspeed#=31
     If players\xspeed#<-31 Then players\xspeed#=-31


     


     ;Now time to do some collision checks. first of we check if collides right block
     If players\xspeed#>0
          Xhitt=False
          b=block_check(players\x#+32,players\y#)
          If b Then players\xspeed#=0 : Xhitt=True ;Stop player moves if hitt
     
     
          If Xhitt=True Then ;Time to reset X position cause player probably in wall.
               x=players\x#
               x=x/32
               x=x*32
               players\x#=x
          End If

     Else ;Second we test if other side of player has collided.
     
          Xhitt=False
          b=block_check(players\x#,players\y#)
          If b Then players\xspeed#=0 : Xhitt=True ;Stop player moves if hitt
     
     
          If Xhitt=True Then ;Time to reset X position cause player probably in wall.
               x=players\x#
               x=x/32
               x=x*32
               players\x#=x+31
          End If

     
     End If
     
     
     
     
     ;Is it time to fall or not ?
     b=block_check(players\x#+1,players\y#+32)
     If b=0 Then b=block_check(players\x#+31,players\y#+32)

     
     If Not b
          players\yspeed#=players\yspeed#+0.1
     Else ; Ouch found ground
          If players\yspeed#>0 
               players\yspeed#=0 
               players\mode$="Normal"
               y=players\y#
               y=y/32
               players\y#=y*32

          End If
     End If

     If players\yspeed#<0
     ;Have player hitt the head :)
     b=block_check(players\x#+1,players\y#)
     If b=0 Then b=block_check(players\x#+31,players\y#)

     If b
      players\yspeed#=1
      y=players\y#
      y=y/32
      y=y*32+33
      players\y#=y
     players\xspeed#=oldxspeed#
     players\x#=oldx#
     
     End If
     End If


     
     ;Activate jump
     If players\mode$="Normal" And KeyHit(k_up)
          players\yspeed#=-6
          players\mode$="Jumping"

     End If



     


     
     
     players\x#=players\x#+players\xspeed#
     players\y#=players\y#+players\yspeed#
     

End Function







Function block_check(xp,yp)
     x=xp/32
     y=yp/32
     If x>=0 And x<map_with And y>=0 And y<map_height+1
     
     obj=map(x,y)
     End If
     Return obj

End Function








Function camera_handle()
;Slowly moves offset to player position
     players.player = First player
     dx#=players\x#-offsetx#-320
     dy#=players\y#-offsety#-240
     offsetx#=offsetx#+(dx#/24)
     offsety#=offsety#+(dy#/24)
End Function







;Draw map at cordinates offset points at
Function redraw()
     Cls ;Clear all
     
     oy=offsety#/32
     ox=offsetx#/32
     
     sx=offsetx#-(ox*32) ;This is scroll bitts for X
     sy=offsety#-(oy*32) ;This is scroll bitts for Y

     Color 128,128,255
     For x=-1 To 20
          For y=-1 To 15
               If ox+x<map_with And oy+y<map_height+1 And ox+x>0 And oy+y>0 ;;Boundery check 1
                    If map(x+ox,y+oy)=1 Then Rect x*32-sx,y*32-sy,31,31 ;Draws a block     
               Else
                    Rect x*32-sx,y*32-sy,31,31      
               End If
          Next 
     Next


     ;Draw players on screen. the red baron.
     players.player=First player
     Color 255,0,0
     Rect players\x#-offsetx#,players\y#-offsety#,32,32


End Function







End ;This is end. so program stops here !

.mapdata
Data "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001"
Data "10000001111111111111111000000000000000000000000000000000000000000000000000000000010000000001"
Data "10000001111111111111100000000000000000000000000000000000000000000000000000000000010000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000010000000001"
Data "10000000000000000000000001111111111111111111111100000000000000000000000000000000010000000001"
Data "10000000000000000000000000001111111111111111111000000000000000000000000000000000010000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000010000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000010000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000010000000001"
Data "10000001111100000001100000000000000001111111111111111111111111000000000000111111110000000001"
Data "10000001111111111111100000000000000110000000000000000000000000000000000000000000000000000001"
Data "10000000000000000000000000000000011000000000000000000000000000000000000000000000000000000001"
Data "10000000000000000000000000000001100000000000000000000000000000000000000000000000000000000001"
Data "11111111111111111111111100000110000000000000000000000000000000000000000000000000000000000001"
Data "10000000000000000000000000011000000000000000000000000000000000000000000000000000000000000001"
Data "11000000000000000000000000000000000000000000000000000000000000111111111110000000000000000001"
Data "10000000000000000000000000000000000000000000000000000000000011111111111100000000000000000001"
Data "10000000000000001111111111111111000000000000000000000000111111111111111111110000000000000001"
Data "10000000000000000000000000000000000000000000000000000000000000011111111111111111111000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001"
Data "10000000000000000000000000000000111111111111111111100000000000000000000000000000000000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000001111111110001"
Data "10100000000000000000000000000000000000000000000000110000000000000000000000000000000000000001"
Data "10100000000000000000000000000000000000000000000000011000000000000000000000000000000000000001"
Data "10100000000000000000000000000000000000000000000000001100000000000000000000000000000000000001"
Data "10100000000000000000000000000000000000000000000000000110000000000000000000000000000000000001"
Data "10111111111110000000000000000000000000000000000000000011000000000000000000000000000000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000001100000000000000001"
Data "11000000000000111111111111100000000000000000000000000000011111111111111111111000000000000001"
Data "11000000000000111111111111100000000000000000000000000000000000000000000000000000000000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111"
Data "10000000000000000000000000000000000000000000000000000000000000000000000000000111000000000001"
Data "10000000000000000000000000000000000000111111111000000000000000000000000000000000000000000001"
Data "10000000000000000000000000000000000000000111000000000001111110000000000000000000000000000001"
Data "10000000000000000000000000000000000000000111000000000011000001111111111111100000000000000001"
Data "10000000000000000000000111111111111110000111000000000110000000000000000000000000000000000001"
Data "10000000000000000000000000000000000000000111000000001100000000000000000000000000000000000001"
Data "10000000001111100000000000000000000000000111000000011000000000000000000000000000000000000001"
Data "10000001111111111110000000000000000000000111100000000000000000000000000000000000000000000001"
Data "11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111"



